s              /  t                                     ax1360P     Metrix AX1060P Power supply (VISA)              ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]    ViUInt16    ViUInt32  Z    This instrument module provides programming support for the Metrix MTX162 (VISA).  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
        This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

(1) Vertical Setup:
Configures various vertical control parameters.

(2) Horizontal: (SubClass)
Configures horizontal control parameters.

(3) Trigger: (SubClass)
Configures the triggering system of the oscilloscope.

(4) Display: (SubClass)
Configures the display parameters.

(5) Hardcopy Setup:
Configures the hardcopy parameters.
        This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions:

(1) Autoset:
Performs an autoset.

(2) Run/Stop :
Enables or disables the acquisition of input signals.
        This class of functions transfers data to or from the instrument.

Functions:

(1) Read Cursors:
This function reads the cursors positions.

(2) Read Measurements:
This function reads one of the automatic measurement of the oscilloscope.

(3) Waveform:  (Subclass)
This class of functions transfers waveform data to or from the instrument.

(4) Transfer:  (Subclass)
This class of functions transfers files to or from the instrument.
    X    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.

        This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "ASRL5"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
Serial      ASRL<port>[::INSTR]


The ASRL keyword is used with Serial instruments.
The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
port                        1 - 255
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.

BFFC0011  Instrument returned invalid response to ID Query

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.    M /    ,    Ressource Name                    f )        ID Query                               }    Instrument Handle                 #      Status                           N                                             "ASRL5"  ! Do Query VI_ON Skip Query VI_OFF    	           	           SUSB-RS parameters, for example : 
"ASRL5" for USB-RS connection with COM5 created.    S    This function configures voltage of the selected input channel of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Polarity) out of range.
BFFC0007  Parameter 7 (Volts/div) out of range.
BFFC0008  Parameter 8 (Offset) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Bandwidth) out of range.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (Volts/div) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     e    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
  
     l    This control sets the voltage of the specified channel. 

Valid Ranges: 0.0 to 32.0 V

Default Value: 5.0
    X#      Status                            ##         Instrument Handle                 $ p         Input                             $ z   Z    Voltage                            	                          CH1 1 CH2 2    5.00    S    This function configures current of the selected input channel of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Polarity) out of range.
BFFC0007  Parameter 7 (Volts/div) out of range.
BFFC0008  Parameter 8 (Offset) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Bandwidth) out of range.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (Volts/div) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     e    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
  
     n    This control sets the current of the specified channel. 

Valid Ranges: 0.00 to 3.20 A

Default Value: 0.10
    &#      Status                            ,\#         Instrument Handle                 , p         Input                             -h z   Z    Current                            	                          CH1 1 CH2 2    0.10    ;    This function configures the tracking of the instrument.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Polarity) out of range.
BFFC0007  Parameter 7 (Volts/div) out of range.
BFFC0008  Parameter 8 (Offset) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Bandwidth) out of range.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (Volts/div) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     p    This control selects the tracking.

Valid Values: 
0 - independant (Default Value)
1 - serial
2 - parallel
  
    /(#      Status                            4#         Instrument Handle                 5X g        Tracking                           	                          "Independant 0 Serial 1 Parallel 2    8    This function controls the output of the instrument. 
    >    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Wait?) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     f    This control valid the output. 

Valid Values:
VI_OFF (0) - Off 
VI_ON  (1) - On   (Default Value)

    6#      Status                            ;6#         Instrument Handle                 ; Y         Out                                	              On VI_ON Off VI_OFF    <    This function reads the output voltage of the instrument.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.
BFFC0005  Parameter 5 (dT) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.
BFFC0008  Parameter 8 (dV) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     (    This control outputs the Vout of CH1.
     (    This control outputs the Vout of CH2.
    =M#         Instrument Handle                 =#      Status                            C     `    CH1 (V)                           C1 >   `    CH2 (V)                                	           	           	           <    This function reads the output current of the instrument.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.
BFFC0005  Parameter 5 (dT) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.
BFFC0008  Parameter 8 (dV) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     (    This control outputs the Iout of CH1.
     '    This control outputs the Iout of CH2.    D#         Instrument Handle                 E@#      Status                            JU     `    CH1 (A)                           J >   `    CH2 (A)                                	           	           	           8    This function save or recall set-up of the instrument.    D    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     |    This control selects between Save and Recall mode.

Valid Range:  
VI_OFF (0) - Recall
VI_ON  (1) - Save  (Default Value)
     z    This control selects the memory.

Valid Values: 
1 - memory 1 (Default Value)
2 - memory 2
3 - memory 3
4 - memory 4
  
    K#      Status                            Q<#         Instrument Handle                 Q | W        Mode                              R_ {        Memory                             	              Save VI_ON Recall VI_OFF               Mem1 1 Mem2 2 Mem3 3 Mem4 4    m    This function writes commands and queries to the instrument to modify parameters and query device settings.    z    The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*CLS\r"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes terminated by '\r' i.e. "*CLS\r" or may be contained in a variable of type string.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    T M E      Write Buffer                      V#      Status                            Y#         Instrument Handle                  "*IDN?\r\n"    	              7    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    ]D M K   `    Number Bytes To Read              a(  H      Read Buffer                       c Mx   `    NumBytes Read                     e#      Status                            iN#         Instrument Handle                  50    	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.
3FFF0085  Unknown status.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL    k =    `    Error Code                        l3 =       Error Message                     l#      Status                            p#         Instrument Handle                  0    	            	           VI_NULL   3    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user what firmware the driver is compatible with, for example:

This instrument driver's Revision Number is "Rev 1.0, 06/2011, CVI 9.0.1" and is compatible with Instrument Firmware Revision "1.64".
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    so = 2       Instrument Driver Revision        s =,       Firmware Revision                 t#      Status                            x)#         Instrument Handle                  	            	            	                   This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    zq#      Status                            ~#         Instrument Handle                  	                     >  W     K*    init                                       %i     K.    SetVoltage                               &p  -     K.    SetCurrent                               .  5     K.    SetTracking                              6  <C     K.    Output                                   =	  Ca     K.    readVout                                 D]  J     K.    readIout                                 K  R     K.    saveRecall                               T  ZG     K.    writeInstrData                           [  i     K.    readInstrData                            k$  q8     K.    errorMessage                             r4  x     K.    revisionQuery                            y  ~     K.    close                                                                      DInitialize                          %Configure Functions                  DSet Voltage                          DSet Current                          DSet Tracking                        Action/Status Functions              DOutput on/off                       	"Data                                 DRead Vout                            DRead Iout                            DSave/Recall Settings                
Utility Functions                    DWrite To Instrument                  DRead Instrument Data                 DError Message                        DRevision Query                       DClose                           