#include <cvidef.h>

/*= <AX1360P> Include File ==================================================*/
 
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __ax1360P_HEADER
#define __ax1360P_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define PREFIX_ERROR_INVALID_CONFIGURATION      (VI_ERROR_INSTR_OFFSET + 0xF0L)


/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/
#define VI_ERROR_PARAMETER9             (_VI_ERROR+0x3FFC0009L)


#define VI_ERROR_AX1360P_ERROR                   (_VI_ERROR+0x3FFC0900L)
#define VI_ERROR_AX1360P_INCONSISTENT_PARAMETER3 (_VI_ERROR+0x3FFC0903L)
#define VI_ERROR_AX1360P_INCONSISTENT_PARAMETER5 (_VI_ERROR+0x3FFC0905L)
#define VI_ERROR_AX1360P_INCONSISTENT_PARAMETER6 (_VI_ERROR+0x3FFC0906L)
#define VI_ERROR_AX1360P_INCONSISTENT_PARAMETER7 (_VI_ERROR+0x3FFC0907L)
#define VI_ERROR_AX1360P_AUTOTEST_PROBLEM        (_VI_ERROR+0x3FFC090BL)
#define VI_ERROR_AX1360P_CHAN_NOT_ACTIVE         (_VI_ERROR+0x3FFC090CL)
#define VI_ERROR_AX1360P_FILE_NOT_FOUND          (_VI_ERROR+0x3FFC090DL)
#define VI_ERROR_AX1360P_EXISTING_FILE           (_VI_ERROR+0x3FFC090EL)
#define VI_ERROR_AX1360P_NO_CHAN_ENABLED         (_VI_ERROR+0x3FFC090FL)
#define VI_ERROR_AX1360P_INVALID_FILE_CONTENT    (_VI_ERROR+0x3FFC0910L)
/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC ax1360P_init (ViRsrc resourceName, ViBoolean IDQuery, ViPSession instrumentHandle);
ViStatus _VI_FUNC ax1360P_SetVoltage (ViSession instrSession, ViInt16 input, ViReal64 voltage);
ViStatus _VI_FUNC ax1360P_SetCurrent (ViSession instrSession, ViInt16 input, ViReal64 current);
ViStatus _VI_FUNC ax1360P_SetTracking (ViSession instrSession, ViInt16 tracking);
ViStatus _VI_FUNC ax1360P_Output (ViSession instrSession, ViBoolean outpout);
ViStatus _VI_FUNC ax1360P_readVout (ViSession instrSession, ViPReal64 v1, ViPReal64 v2);
ViStatus _VI_FUNC ax1360P_readIout (ViSession instrSession, ViPReal64 i1, ViPReal64 i2);
ViStatus _VI_FUNC ax1360P_saveRecall (ViSession instrSession, ViBoolean mode, ViInt16 memory);
ViStatus _VI_FUNC ax1360P_writeInstrData (ViSession instrumentHandle, ViString writeBuffer);
ViStatus _VI_FUNC ax1360P_readInstrData (ViSession instrumentHandle, ViInt32 numberBytesToRead, ViChar _VI_FAR readBuffer[], ViPInt32 numBytesRead);
ViStatus _VI_FUNC ax1360P_errorMessage (ViSession instrumentHandle, ViStatus errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC ax1360P_revisionQuery (ViSession instrumentHandle, ViChar _VI_FAR instrumentDriverRevision[], ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC ax1360P_close (ViSession instrumentHandle);



#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
