EMMC_DRIVE="/dev/mmcblk2"
KERNEL_PARTITION="/dev/mmcblk2p1"
DOC_PARTTION="/dev/mmcblk2p7"
KERNEL_FS_MOUNT_POINT='/media/boot'
NEW_ROOTFS_MOUNT_POINT='/media/rootfs'
PRIVATE_FS_MOUNT_POINT='/media/private'
DOC_FS_MOUNT_POINT='/media/doc'
cd "$( dirname "$0" )"
export WORK_DIR=`pwd`
DOC_PARTITION="/dev/mmcblk2p7"
export `awk '{print $2}' /proc/cmdline`
case $root in
    /dev/mmcblk2p2)
        NEW_ROOTFS_PARTITION="/dev/mmcblk2p3"
        ;;
    *)
        NEW_ROOTFS_PARTITION="/dev/mmcblk2p2"
        ;;
esac
umount ${KERNEL_PARTITION}
dd if=${WORK_DIR}/sIV-kernel.fat of=${KERNEL_PARTITION} bs=1M
umount ${NEW_ROOTFS_PARTITION}
dd if=${WORK_DIR}/sIV-rootfs.ext3 of=${NEW_ROOTFS_PARTITION} bs=1M
umount ${DOC_PARTITION}
dd if=${WORK_DIR}/sIV-doc.fat of=${DOC_PARTITION} bs=1M
if [ ! -d ${KERNEL_FS_MOUNT_POINT} ]; then
    mkdir -p ${KERNEL_FS_MOUNT_POINT}
fi
mount ${KERNEL_PARTITION} ${KERNEL_FS_MOUNT_POINT}
case $root in
    /dev/mmcblk2p2)
        sed -i -e 's/mmc_rootfs_part=p[23]/mmc_rootfs_part=p3/' \
                   ${KERNEL_FS_MOUNT_POINT}/uLinuxEnv.txt
        ;;
    *)
        sed -i -e 's/mmc_rootfs_part=p[23]/mmc_rootfs_part=p2/' \
                   ${KERNEL_FS_MOUNT_POINT}/uLinuxEnv.txt
        ;;
esac
if [ ! -d ${NEW_ROOTFS_MOUNT_POINT} ]; then
    mkdir -p ${NEW_ROOTFS_MOUNT_POINT}
fi
mount ${NEW_ROOTFS_PARTITION} ${NEW_ROOTFS_MOUNT_POINT}
if [ -f ${NEW_ROOTFS_MOUNT_POINT}/etc/pointercal ]; then
    rm ${NEW_ROOTFS_MOUNT_POINT}/etc/pointercal
fi
if [ -f ${PRIVATE_FS_MOUNT_POINT}/setup.cfg ]; then
    rm ${PRIVATE_FS_MOUNT_POINT}/setup.cfg
fi
if [ -f ${PRIVATE_FS_MOUNT_POINT}/sta_settings.conf ]; then
    rm ${PRIVATE_FS_MOUNT_POINT}/sta_settings.conf
fi
sync
umount ${KERNEL_PARTITION}
umount ${NEW_ROOTFS_PARTITION}
reboot
